/* 
 *  SessionDetailsForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Pair;

public class SessionDetailsForm {

    private final Stage sessionDetails = new Stage();
    private final MenuItem addSession;
    private static final Logger LOG = Logger.getLogger(SessionDetailsForm.class);
    public SessionDetailsForm(ClientSessionExecutor clientSessionExe, String css) {
        sessionDetails.titleProperty().set("Session Details");
        addSession = new MenuItem("Session Details");
 
        BorderPane sessionDetailsborder = new BorderPane();
        Scene sessionDetailsScene = new Scene(sessionDetailsborder, 300, 200);
        sessionDetailsScene.getStylesheets().add(css);
        sessionDetails.setScene(sessionDetailsScene);

        addSession.setOnAction((ActionEvent t) -> {
            LOG.info("SessionMenuItem()");
            sessionDetails.show();
            clientSessionExe.getSessionData();
        });
    }

    public MenuItem getMenuItem() {
        return this.addSession;
    }

    public void update(List<Pair<String, String>> newData) {
        BorderPane bp = (BorderPane) sessionDetails.sceneProperty().get().getRoot();
        bp.setLeft(GUIUtil.properties(newData));
    }
}
